﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Serialization;

namespace IndianHealthService.BMXNet.WinForm.Configuration
{
    /// <summary>
    /// Specification for BMX RPMS Connection.  Instances of this class are serialized as XML
    /// to a PersisentStore and are used is picklists for users to select from.  
    /// </summary>
    public class RpmsConnectionSpec
    {

        [XmlIgnore]
        internal bool HasNameSpace
        {
            get { return this.NameSpace != null && this.NameSpace.Length > 0; }
        }
        
        private bool _isManageSpecsPlaceHolder = false;

        [XmlIgnore]
        internal bool IsManageSpecsPlaceHolder
        {
            get { return _isManageSpecsPlaceHolder; }
            set { _isManageSpecsPlaceHolder = value; }
        }
        
        private bool _isFromCommandLine = false;

        [XmlIgnore]
        internal bool IsFromCommandLine
        {
            get { return _isFromCommandLine; }
            set { _isFromCommandLine = value; }
        }

        private String _name = null;

        /// <summary>
        /// The required display name of a connection used in pick lists
        /// </summary>
        [XmlAttribute("Name")]
        public String Name
        {
            get { return _name; }
            set { _name = value; }
        }

        private String _server = null;

        /// <summary>
        /// The required Name/IP Address of the RPMS Host
        /// </summary>
        [XmlAttribute("Server")]
        public String Server
        {
            get { return _server; }
            set { _server = value; }
        }

        private int _receiveTimeout = 0;

        /// <summary>
        /// The optional time in millseconds to wait for a response from RPMS
        /// </summary>
        [XmlAttribute("ReceiveTimeout")]
        public int ReceiveTimeout
        {
            get { return _receiveTimeout; }
            set { _receiveTimeout = value; }
        }
        private int _sendTimeout = 0;

        /// <summary>
        /// The optional time in millseconds to wait when sending a request to RPMS
        /// </summary>
        [XmlAttribute("SendTimeout")]
        public int SendTimeout
        {
            get { return _sendTimeout; }
            set { _sendTimeout = value; }
        }
   
        private int _port = 0;

        /// <summary>
        /// The required TCP/IP port number of the RPMS BMX Broker 
        /// </summary>
        [XmlAttribute("Port")]
        public int Port
        {
            get { return _port; }
            set { _port = value; }
        }

        private String _nameSpace = null;

        /// <summary>
        /// The optional Namespace to use in RPMS.  Will default to BMX Brokers namespace.
        /// </summary>
        [XmlAttribute("NameSpace")]
        public String NameSpace
        {
            get { return _nameSpace; }
            set { _nameSpace = value; }
        }

        private bool _isDefault = false;

        /// <summary>
        /// The optional flag to specify this connection as the users default.
        /// </summary>
        [XmlAttribute("IsDefault")]
        public bool IsDefault
        {
            get { return _isDefault; }
            set { _isDefault = value; }
        }

        private bool _useWindowsAuthentication = false;

        /// <summary>
        /// The optional flag to specify that WindowsAuthenication should be attempted.
        /// </summary>
        [XmlAttribute("UseWindowsAuthentication")]
        public bool UseWindowsAuthentication
        {
            get { return _useWindowsAuthentication; }
            set { _useWindowsAuthentication = value; }
        }

        private bool _useDefaultNamespace = true;

        /// <summary>
        /// The optional flag to specify that the BMX Broker default namespace should be used.
        /// </summary>
        [XmlAttribute("UseDefaultNamespace")]
        public bool UseDefaultNamespace
        {
            get { return _useDefaultNamespace; }
            set { _useDefaultNamespace = value; }
        }


    }
}
